class ChatCommand 
{
public:	

	// Static functions and data, dont need to be called from an object
	static HashTemplateClass<StringClass, ChatCommand *> CommandsMap; // This is our hash map, we put ChatCommand object pointers here
																	// That are triggered by a StringClass trigger text

	static void Load(); // This is our loading code, call this from somewhere
	static void Unload(); // Unloads all chat commands related stuff

	void Startup(const char* Trigger); // Loads a ChatCommand object and adds it to the hash table

	virtual void Activate(int ID, int Type, StringClass Msg); // The default Activate() function called if not defined by an inheriting class
};

// a class that inherits the ChatCommand class, this one implements the !help command
class Help : public ChatCommand
{
public:
	void Activate(int ID, int Type, StringClass Msg); // The code to execute when this function is called in the chat hook by its trigger
};